#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;


struct Move {
    long long x,y;
    int id;
    double angle;
};

int comp(Move& a, Move& b) {
    return a.angle < b.angle;
}

int main() {
    int n;
    cin>>n;
    vector<Move> moves(n);
    for (int i=0;i<n;i++){
        long long x,y;
        cin >> x >> y;
        moves[i]={x,y,i+1,atan2((double)y,(double)x)};
    }
    sort(moves.begin(),moves.end(),comp);
    moves.resize(2*n);
    for (int i = 0; i < n; ++i) {
        Move m=moves[i];
        m.angle+=2*M_PI;
        moves[i+n]=m;
    }
    int l=0,r=l;
    long long sumx=moves[0].x,sumy=moves[0].y;
    long long bestans=sumx*sumx+sumy*sumy; int bestl=0,bestr=0;
    long long curans;
    for(;l<2*n;l++){
        sumx=0;sumy=0;
        for(r=l;r<2*n && r<l+n;r++){
            sumx+=moves[r].x; sumy+=moves[r].y;
            curans=sumx*sumx+sumy*sumy;
            if(curans>bestans){bestl=l;bestr=r;bestans=curans;}
        }
    }
    cout<<bestr-bestl+1<<endl;
    for(int i=bestl;i<=bestr;i++)cout<<moves[i%n].id<<' ';
    return 0;
}